
var toolbarOptions = [
  ['bold', 'italic', 'underline', 'strike'],        // toggled buttons
  ['blockquote', 'code-block'],

  [{ 'header': 1 }, { 'header': 2 }],               // custom button values
  [{ 'list': 'ordered'}, { 'list': 'bullet' }],
  [{ 'script': 'sub'}, { 'script': 'super' }],      // superscript/subscript
  [{ 'indent': '-1'}, { 'indent': '+1' }],          // outdent/indent
  [{ 'direction': 'rtl' }],                         // text direction

  [{ 'size': ['small', false, 'large', 'huge'] }],  // custom dropdown
  [{ 'header': [1, 2, 3, 4, 5, 6, false] }],

  [{ 'color': [] }, { 'background': [] }],          // dropdown with defaults from theme
  [{ 'font': [] }],
  [{ 'align': [] }],

  ['clean']                                         // remove formatting button
];

var editorid = $('#editorid').html().trim();
var quill;

if (($('#'+editorid+' .ql-editor') == undefined || 
$('#'+editorid+' .ql-editor').length == 0) &&
$('#'+editorid).attr('contenteditable') != 'true') {

        document.getElementById(editorid).parentElement.classList.remove('editable');
        document.getElementById(editorid).parentElement.classList.add('editable');
        document.getElementById(editorid).setAttribute("contenteditable", "true");

  quill = new Quill('#'+editorid, {
    theme: 'snow'
  });
}

  $('#'+editorid).parent().removeClass('inactive')

  if (quill)
  quill.enable(true);
